//------------------------------------------------------------------
//  JsonUuid.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeClasses from "../../util/classes";
import * as axeString from "../../util/string";
import { JsonType } from './JsonType';
import { JsonTypeError } from './JsonTypeError';
//------------------------------------------------------------------

/** Marks a class attribute as a UUID.
 *
 * This is a string object in Typescript and a UUID object in Python.
 */
export class JsonUuid extends JsonType
{
  //----------------------------------------------------------------
  // Properties
  //----------------------------------------------------------------

  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonUuid object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Methods
  //------------------------------------------------------------------

  /** Checks that the specified value can be converted to JSON.
   *
   * @param value The value to validate.
   *
   * @return None if the value is OK, or a JsonTypeError if there is a problem.
   */
  validate(value: any) : JsonTypeError
  {
    if (!(!value || typeof value == 'string'))
    {
      let msg = ('is of type uuid, ' +
                 'but the value is of type ' + axeClasses.className(value) +
                 '.  Value: ' + axeString.format(value));
      return new JsonTypeError(msg);
    }
    else
    {
      return null;
    }
  }

  /** Checks that the specified JSON string can be converted to an object.
   *
   * @param value The JSON value to validate.
   *
   * @return None if the value is OK, or a JsonTypeError if there is a problem.
   */
  validateJson(value: any) : JsonTypeError
  {
    if (!value)
    {
      return null;
    }
    else if (typeof value != 'string')
    {
      let msg = ('is of type uuid (string), ' +
                 'but the value is of type ' + axeClasses.className(value) +
                 '.  Value: ' + axeString.format(value));
      return new JsonTypeError(msg);
    }
    else
    {
      return null;
    }
  }

  /** Encodes a value into JSON-ready value.
   */
  encode(value: any) : any
  {
    if (value === null)
    {
      return null;
    }
    else
    {
      return value;
    }
  }

  /** Decodes a value from a JSON-ready value.
   */
  decode(value: any) : any
  {
    if (value === null)
    {
      return null;
    }
    else
    {
      return value;
    }
  }

  /** Decodes any links in a JSON-ready value.
   */
  decodeLinks(parents: Array<object>, value: object) : object
  {
    return value;
  }

  /** Returns a string representation of this object.
   */
  toString() : string
  {
    let propertyNames: Array<string> = [
    ];
    return axeString.formatObject("JsonUuid", this, propertyNames);
  }

} // END class JsonUuid
