//------------------------------------------------------------------
//  TestJsonAny.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../../util/string";
import { UnitTest } from "../../../unittest/UnitTest";
import { UnitTestRunner } from "../../../unittest/UnitTestRunner";
import { JsonAny } from "../JsonAny";
//------------------------------------------------------------------

/** Unit test for the JsonAny class.
 */
export class TestJsonAny extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonAny object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test the validate() method.
   */
  testValidate() : void
  {
    let jsonType = new JsonAny();
    this.assertNull('any', jsonType.validate(null));
    this.assertNull('any', jsonType.validate('foo'));
    this.assertNull('any', jsonType.validate(true));
    this.assertNull('any', jsonType.validate(3));
    this.assertNull('any', jsonType.validate([[[]]]));
  }

  /** Test the validateJson() method.
   */
  testValidateJson() : void
  {
    let jsonType = new JsonAny();
    this.assertNull('any', jsonType.validateJson(null));
    this.assertNull('any', jsonType.validateJson('foo'));
    this.assertNull('any', jsonType.validateJson(true));
    this.assertNull('any', jsonType.validateJson(3));
    this.assertNull('any', jsonType.validateJson([[[]]]));
  }

  /** Test the encode() method.
   */
  testEncode() : void
  {
    let jsonType = new JsonAny();
    this.assertEqual('no change', 3, jsonType.encode(3));
  }

  /** Test the decode() method.
   */
  testDecode() : void
  {
    let jsonType = new JsonAny();
    this.assertEqual('no change', 3, jsonType.decode(3));
  }

  /** Test the decodeLinks() method.
   */
  testDecodeLinks() : void
  {
    let jsonType = new JsonAny();
    this.assertEqual('null', null, jsonType.decodeLinks([], null));
    this.assertEqual('no change', {x: 3}, jsonType.decodeLinks([], {x: 3}));
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonAny

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonAny());
