//------------------------------------------------------------------
//  gui.js
//  Copyright 2013 AppliedMinds, Inc.
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as d3 from "d3";
//------------------------------------------------------------------

//------------------------------------------------------------------
// Functions
//------------------------------------------------------------------

/** Scrolls a specified DOM element into view in a scrollable element.
 */
  /* TODO convert JQuery to Element
export function scrollIntoView(scrollToElem: JQuery,
                               scrollingElem: JQuery) : void
{
  scrollToElem = angular.element(scrollToElem);
  scrollingElem = angular.element(scrollingElem);

  // The height of the whole content view, including the parts not visible
  // because they're off screen.
  var contentTop = scrollingElem.scrollTop();

  // The height of what's visible in the scroll view.
  var viewPortHeight = scrollingElem.height();

  // How far down the scroll view the element is.
  var scrollToTop = scrollToElem.position().top -
      scrollingElem.position().top;

  var scrollToHeight = scrollToElem.outerHeight();
  var scrollToBottom = scrollToTop + scrollToHeight;

  var topDelta = 0;

  // If the child is off the bottom, scroll up.
  if (scrollToBottom > viewPortHeight)
  {
    topDelta = scrollToBottom - viewPortHeight;
  }

  // If the child is off the top, scroll down.
  if (scrollToTop - topDelta < 0)
  {
    topDelta += (scrollToTop - topDelta);
  }

  var newContentTop = contentTop + topDelta;
  var animateMap = { 'scrollTop' : newContentTop + "px" };
  scrollingElem.animate(animateMap, 500, 'swing');
};
  */

/** A setVisible() wrapper for an object with a show()/hide() method.
 *
 * A simple helper function that lets you call show() or hide() on
 * on a object depending on a boolean.
 *
 * @param obj The object to call 'show' or 'hide' on.
 * @param visible Whether the object should be shown or hidden.
 */
export function setVisible(obj: any, visible: boolean) : void
{
  if (typeof obj.show != 'function' ||
      typeof obj.hide != 'function')
  {
    console.error("Object is missing show/hide.  Object:", obj);
    throw Error("Object is missing show/hide.  Object:" + obj);
  }

  if (visible)
  {
    obj.show();
  }
  else
  {
    obj.hide();
  }
}

/** Returns the height of the window.
 */
  /* TODO make work without jquery
export function windowHeight() : number
{
  return window.innerHeight ? window.innerHeight : jQuery(window).innerHeight();
};
*/

/** Returns an x/y placement of a DOM node near another node.
 *
 * The placement will be chosen to have the DOM node fit in the
 * window.
 *
 * @param targetNode The node that placedNode should be near.
 * @param placedNode The node that will be placed on the screen.
 *
 * @return An object with x and y attributes that are the location
 *         that placedNode should be placed at.
 */
  /* TODO make work without jquery
export function placeNear(targetNode: JQuery, placedNode: JQuery) : XyPoint
{
  var placedHeight = placedNode.height();
  var targetXy = targetNode.offset();
  var targetHeightStr = targetNode.css('height');

  // Parse the string "Npx" into the number "N".
  targetHeightStr = targetHeightStr.slice(0, targetHeightStr.length - 2);
  var targetHeight = parseFloat(targetHeightStr);

  var newTop = targetXy.top + targetHeight;
  var newBottom = newTop + placedHeight;

  // Whether the list will go off the bottom if opened "down".
  var isOffTheBottom = newBottom > axe.gui.windowHeight();

  // Whether the list will go off the top if opened "up".
  var isOffTheTop = newTop < placedHeight;

  // If the list would go off the bottom of the page, open it "up" instead.
  if (isOffTheBottom && !isOffTheTop)
  {
    newTop = targetXy.top - placedHeight;
  }

  return {'x': targetXy.left, 'y': newTop};
};
*/

/** Returns all the child input objects for an Angular form.
 */
  /* TODO make work with angular 2.
export function formInputs(form: angular.IFormController) :
  Array<angular.INgModelController>
{
  var inputs: Array<angular.INgModelController> = [];

  // Look at all the properties of the form.
  // Ignore non-own properties and Angular variables that begin with '$'.

  for (var inputName in form)
  {
    if (form.hasOwnProperty(inputName) &&
        inputName &&
        inputName.charAt(0) != '$')
    {
      var input = form[inputName];
      inputs.push(input);
    }
  }

  return inputs;
};
  */

/** Clears all errors in the specified Angular form object.
 */
  /* TODO Make work with Angular 2.
export function clearFormErrors(form: angular.IFormController) : void
{
  var inputs = axe.gui.formInputs(form);

  for (var i = 0; i < inputs.length; ++i)
  {
    var input = inputs[i];

    axe.gui.clearInputError(input, false);
  }
};
*/

/** Clears all errors in the specified Angular input object.
 */
  /* TODO make work with angular 2
export function clearInputError(input: angular.INgModelController,
                                clearRequired: boolean) : void
{
  for (var errorName in input.$error)
  {
    if (!input.$error.hasOwnProperty(errorName))
    {
      continue;
    }

    // Don't clear required errors, or the initial state of the
    // form will be wrong.
    if (errorName == 'required' && !clearRequired)
    {
      continue;
    }

    input.$setValidity(errorName, true);
  }
};
*/

/** Find a parent of the specified node type.
 *
 * Give a jQuery selection, returns the first parent of the specified
 * node type.  For example:
 *
 *  findAncestor(jQuery("#foo"), "svg")
 *
 * will return the first <svg> parent.
 *
 * @param jQuerySelection A JQuery selection.
 * @param nodeName A string node name.
 *
 * @return A JQuery selection that is the parent.
 */
  /* TODO make work with angular 2
export function findAncestor(jQuerySelection: JQuery, nodeName: string) :
  JQuery
{
  var jnode = jQuerySelection.parent();
  while (jnode.length > 0 && jnode[0].nodeName != nodeName)
  {
    jnode = jnode.parent();
  }

  return jnode;
};
*/

/** Finds the D3 mouse/touch position.
 *
 * @param node The position will be returned relative to this node.
 * @param isMouse If true, the mouse position will be returned.
 *                If false, the touch position will be returned.
 *
 * @return An [x, y] array, or NULL if there is no touch position available.
 */
  /* TODO make work with angular 2
export function mouseTouchPosition(node: SVGGElement, isMouse: boolean) :
  Array<number>
{
  if (isMouse)
  {
    return d3.mouse(node);
  }
  else
  {
    let touchList = d3.touches(node);
    if (touchList && touchList.length > 0)
    {
      return touchList[0];
    }
    else
    {
      return null;
    }
  }
}
*/
