//------------------------------------------------------------------
//  ng.ts
//  Copyright 2018 Applied Invention, LLC
//------------------------------------------------------------------

/* Contains references to frequenty-used Angular components.
 *
 * Use this module like so:
 *
 *    import * as axeNg from './path/to/ng'
 *    axeNg.http.get(...)
 */

//------------------------------------------------------------------
import * as axeString from './string';
import { HttpClient } from '@angular/common/http';
import { Location } from '@angular/common';
//------------------------------------------------------------------

//------------------------------------------------------------------
// Constants
//------------------------------------------------------------------

export let httpClient: HttpClient;
export let location: Location;

//------------------------------------------------------------------
// Functions
//------------------------------------------------------------------

/** Initialize the properties in this module.
 */
export function init(srcHttpClient: HttpClient,
                     srcLocation: Location) : void
{
  httpClient = srcHttpClient;
  location = srcLocation;
}
