//------------------------------------------------------------------
//  TestString.ts
//  Copyright 2016 Applied Invention, LLC.
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../string";
import { UnitTest } from "../../unittest/UnitTest";
import { UnitTestRunner } from "../../unittest/UnitTestRunner";
//------------------------------------------------------------------

/** Unit test for the String class.
 */
export class TestString extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new String object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods
  //------------------------------------------------------------------

  /** Test the substring method.
   */
  testSubstring() : void
  {
    let substring = axeString.substring;

    this.assertEqual("empty", "", substring("", 0, 0));
    this.assertEqual("empty", "", substring("abc", 0, 0));
    this.assertEqual("empty", "", substring("abc", 2, 2));
    this.assertEqual("all", "abc", substring("abc", 0, 3));
    this.assertEqual("begin outside", "abc", substring("abc", -43, 3));
    this.assertEqual("end outside", "abc", substring("abc", 0, 13));
    this.assertEqual("both outside", "abc", substring("abc", -43, 13));
    this.assertEqual("negative", "b", substring("abc", -2, -1));
  }

  //------------------------------------------------------------------
  // Private Utility Methods
  //------------------------------------------------------------------

} // END class TestString

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestString());
