//------------------------------------------------------------------
//  types.ts
//  Copyright 2016 Applied Invention, LLC.
//------------------------------------------------------------------


//------------------------------------------------------------------
// Constants
//------------------------------------------------------------------

/** A function that takes any arguments and has any return type.
 */
export type AnyFunction = (...args: any[]) => any;

/** An object that is being used as a map.
 *
 * The generic T type determines what kind of value may be stored.
 * The most common uses of T are <any> or <string>.
 */
export interface ObjectMap<T>
{
  [key: string]: T;
}

/** Any class' constructor function.
 *
 * For example, if you have classes A and B:
 *
 *  class A { constructor(string){} };
 *  class B { constructor(){} };
 *
 * You can have a pointer to either class.
 *
 *   let x: AnyCtor = A;
 *   x = B;
 */
export interface AnyCtor
{
  new(...args: Array<any>) : any;
}

//------------------------------------------------------------------
// Functions
//------------------------------------------------------------------
