//------------------------------------------------------------------
//  TestJsonUuid.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../../util/string";
import { Day } from "../../../date/Day";
import { JsonUuid } from "../JsonUuid";
import { UnitTest } from "../../../unittest/UnitTest";
import { UnitTestRunner } from "../../../unittest/UnitTestRunner";
//------------------------------------------------------------------

/** Unit test for the JsonUuid class.
 */
export class TestJsonUuid extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonUuid object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test the encode/decode() method.
   */
  testEncodeDecode() : void
  {
    const validStr: any = '3360eecf-6a71-4621-bd26-e7d8357f2fdb';

    let jsonType = new JsonUuid();

    // Validate typescript.

    this.assertEqual('uuid valid',
                     null, jsonType.validate(validStr));
    this.assertEqual('null valid', null, jsonType.validate(null));

    this.assertNotNull('float invalid', jsonType.validate(3.14));

    // Validate JSON.

    this.assertEqual('date valid JSON',
                     null,
                     jsonType.validateJson(validStr));
    this.assertEqual('null valid JSON', null, jsonType.validateJson(null));

    this.assertNotNull('float invalid', jsonType.validateJson(3.14));

    // Encode.

    this.assertEqual('encode',
                     validStr, jsonType.encode(validStr));
    this.assertEqual('null', null, jsonType.encode(null));

    // Decode.

    this.assertEqual('decode',
                     validStr, jsonType.decode(validStr));
    this.assertEqual('null', null, jsonType.decode(null));

    // Decode links.

    this.assertEqual('decodeLinks',
                     validStr,
                     jsonType.decodeLinks([], validStr));

    this.assertEqual('null', null, jsonType.decodeLinks([], null));
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonUuid

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonUuid());
