//------------------------------------------------------------------
//  TestDay.ts
//  Copyright 2016 Applied Invention, LLC.
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../util/string";
import { UnitTest } from "../../unittest/UnitTest";
import { UnitTestRunner } from "../../unittest/UnitTestRunner";
import { Day } from "../Day";
//------------------------------------------------------------------

/** Unit test for the Day class.
 */
export class TestDay extends UnitTest
{
  //----------------------------------------------------------------
  // Private Member Variables
  //----------------------------------------------------------------

  private static mSecPerMinute: number = 60 * 1000;
  private static mSecPerHour: number = 60 * TestDay.mSecPerMinute;
  private static mSecPerDay: number = 24 * TestDay.mSecPerHour;

  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new Day object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods
  //------------------------------------------------------------------

  /** Test creating and accessing the Day.
   */
  testDay() : void
  {
    // Create from long.

    let day = new Day(TestDay.mSecPerDay);

    this.assertEqual("valueOf", TestDay.mSecPerDay, day.valueOf());

    // Create for today.

    day = Day.today();

    this.assertEqual("day positive", true, day.valueOf() > 0);

    // Create from year, month, day.

    day = new Day(2001, 4, 20);

    let theDate = new Date(2001, 4, 20);

    this.assertEqual("year, month, day", day.valueOf(), theDate.valueOf());
  }

  /** Test normalizing a day.
   */
  testNormalize() : void
  {
    let now = new Date();
    let today = Day.today();

    let mSecsBeforeNow: number = now.getTime() - today.valueOf();

    this.assertEqual("today before now", true, mSecsBeforeNow > 0);
    this.assertEqual("today within a day",
                     true,
                     mSecsBeforeNow < TestDay.mSecPerDay);
  }

  /** Test equals.
   */
  testEquals() : void
  {
    let day1 = new Day(1);
    let day1b = new Day(1);
    let day2 = new Day(2);

    this.assertEqual("same object", true, day1.equals(day1));
    this.assertEqual("same value", true, day1.equals(day1b));
    this.assertEqual("different value", false, day1.equals(day2));
    this.assertEqual("null", false, day1.equals(null));
  }

  /** Test toString().
   */
  testString() : void
  {
    let day = new Day(0);

    // Don't test the format.  Just make sure it doesn't throw an exception.
    day.toString();
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestDay

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestDay());
